<?php
// Callback for e-bdpay gateway
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

use WHMCS\Config\Setting;

// Collect request inputs (support both GET and POST)
$invoiceId = isset($_REQUEST['invoice']) ? trim($_REQUEST['invoice']) : '';
$transactionId = isset($_REQUEST['transactionId']) ? trim($_REQUEST['transactionId']) : '';
$paymentAmount = isset($_REQUEST['paymentAmount']) ? trim($_REQUEST['paymentAmount']) : '';
$paymentFee = isset($_REQUEST['paymentFee']) ? trim($_REQUEST['paymentFee']) : 0;
$gatewayModuleName = "e-bdpay";

// Basic validation
if (empty($transactionId)) {
    logTransaction($gatewayModuleName, $_REQUEST, "Callback Error: Missing transactionId");
    echo "Failed. Missing transactionId";
    exit;
}

// Verify with remote endpoint
$apikey = isset($_REQUEST['api']) ? $_REQUEST['api'] : '';
$verifyEndpoint = 'https://pay.e-bdpay.com/api/payment/verify';
$payload = array("transaction_id" => $transactionId);

$headers = array(
    'Content-Type: application/json',
    'API-KEY: ' . $apikey,
);

$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => $verifyEndpoint,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 30,
));
$response = curl_exec($curl);
$curlErr = curl_error($curl);
curl_close($curl);

if ($response === false || !empty($curlErr)) {
    logTransaction($gatewayModuleName, $_REQUEST, "Verify cURL Error: " . $curlErr);
    echo "Failed. Verification error";
    exit;
}

$res = json_decode($response, true);
if (!is_array($res)) {
    logTransaction($gatewayModuleName, $_REQUEST, "Verify Response invalid JSON: " . $response);
    echo "Failed. Invalid verify response";
    exit;
}

// Expecting status value 'COMPLETED' or boolean true depending on API
$statusValue = isset($res['status']) ? $res['status'] : (isset($res['success']) ? $res['success'] : null);

if ($statusValue === "COMPLETED" || $statusValue === true || $statusValue === "true") {
    // Ensure invoice exists
    if (empty($invoiceId)) {
        logTransaction($gatewayModuleName, $_REQUEST, "Callback Error: Missing invoice id");
        echo "Failed. Missing invoice id";
        exit;
    }

    // Normalize amounts
    $amount = floatval($paymentAmount);
    $fee = floatval($paymentFee);

    try {
        // Add payment to invoice
        addInvoicePayment($invoiceId, $transactionId, $amount, $fee, $gatewayModuleName);
        logTransaction($gatewayModuleName, $_REQUEST, "Payment Applied: Invoice #$invoiceId, TXID: $transactionId");
        $systemUrl = Setting::getValue('SystemURL');
        // Redirect user to invoice page on success
        echo '<script>location.href = "' . $systemUrl . '/viewinvoice.php?id=' . intval($invoiceId) . '";</script>';
        exit;
    } catch (Exception $e) {
        logTransaction($gatewayModuleName, $_REQUEST, "AddInvoicePayment Exception: " . $e->getMessage());
        echo "Failed to add payment: " . $e->getMessage();
        exit;
    }
} else {
    logTransaction($gatewayModuleName, $_REQUEST, "Verify failed: " . json_encode($res));
    echo "Failed. Payment not completed";
    exit;
}
?>